<?php include_once('includes/head.php'); ?>
    <style>
        /* Add these spacing utilities and fixes */
        .nk-block {
            margin-bottom: 30px;
        }
        
        .nk-block-head {
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #e3ebf6;
        }
        
        .row.g-gs {
            --bs-gutter-x: 1.5rem;
            --bs-gutter-y: 1.5rem;
            margin-bottom: 30px;
        }
        
        /* Metric Cards with Colors */
        .metric-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 4px solid;
            height: 100%;
            margin-bottom: 0;
            transition: transform 0.3s ease;
        }
        
        .metric-card:hover {
            transform: translateY(-5px);
        }
        
        .metric-card.revenue {
            border-left-color: #10b981;
        }
        
        .metric-card.bets {
            border-left-color: #3b82f6;
        }
        
        .metric-card.transactions {
            border-left-color: #8b5cf6;
        }
        
        .metric-card.payouts {
            border-left-color: #f59e0b;
        }
        
        .metric-icon {
            width: 45px;
            height: 45px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            margin-bottom: 12px;
        }
        
        .metric-card.revenue .metric-icon {
            background: #d1fae5;
            color: #10b981;
        }
        
        .metric-card.bets .metric-icon {
            background: #dbeafe;
            color: #3b82f6;
        }
        
        .metric-card.transactions .metric-icon {
            background: #ede9fe;
            color: #8b5cf6;
        }
        
        .metric-card.payouts .metric-icon {
            background: #fef3c7;
            color: #f59e0b;
        }
        
        .metric-value {
            font-size: 24px;
            font-weight: 700;
            margin: 10px 0 5px 0;
            color: #1e293b;
        }
        
        .metric-label {
            color: #6b7280;
            font-size: 14px;
            font-weight: 500;
        }
        
        .filter-section {
            background: #f8fafc;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            border: 1px solid #e3ebf6;
            clear: both;
        }
        
        .filter-group {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
            margin-top: 15px;
        }
        
        .filter-item {
            flex: 1;
            min-width: 150px;
        }
        
        .filter-item label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #1e293b;
        }
        
        .admin-section {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            border: 1px solid #e3ebf6;
            clear: both;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        
        .card-title-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #e3ebf6;
        }
        
        .card-title h6 {
            margin: 0;
            font-size: 1.1rem;
            font-weight: 600;
            color: #1e293b;
        }
        
        .card-tools {
            color: #6b7280;
            font-size: 0.9rem;
        }
        
        .table-responsive {
            margin-bottom: 20px;
        }
        
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
            padding-top: 15px;
            border-top: 1px solid #e3ebf6;
        }
        
        .page-item {
            padding: 8px 12px;
            border-radius: 6px;
            cursor: pointer;
            border: 1px solid #e3ebf6;
            transition: all 0.3s ease;
        }
        
        .page-item:hover {
            background: #f1f5f9;
        }
        
        .page-item.active {
            background: #3b82f6;
            color: white;
            border-color: #3b82f6;
        }
        
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 0;
        }
        
        .section-title i {
            color: #3b82f6;
        }
        
        .quick-stats {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }
        
        .stat-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px;
            background: #f8fafc;
            border-radius: 6px;
            border: 1px solid #e3ebf6;
            color: #1e293b;
        }
        
        .stat-row strong {
            display: flex;
            justify-content: space-between;
            width: 100%;
            color: #1e293b;
        }
        
        /* Status Badges */
        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .status-completed {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-pending {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-processing {
            background: #dbeafe;
            color: #1e40af;
        }
        
        /* Bet Type Badges */
        .bet-type-badge {
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 11px;
            font-weight: 600;
        }
        
        .bet-5-90 {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .bet-6-90 {
            background: #d1fae5;
            color: #065f46;
        }
        
        /* Winning Numbers */
        .winning-numbers {
            display: flex;
            gap: 6px;
            flex-wrap: wrap;
        }
        
        .winning-number {
            width: 30px;
            height: 30px;
            border-radius: 6px;
            background: #dbeafe;
            color: #1e40af;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 600;
        }
        
        /* Amount Colors */
        .amount-negative {
            color: #ef4444;
            font-weight: 600;
        }
        
        .amount-positive {
            color: #10b981;
            font-weight: 600;
        }
        
        /* Export Button */
        .export-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .export-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        /* Container spacing */
        .container-fluid {
            padding-top: 20px;
            padding-bottom: 20px;
        }
        /* Agent header and collapse styles */
        .agent-header-row td {
            background: #f1f5f9;
            font-weight: 700;
            padding: 12px 16px;
        }
        .agent-toggle {
            cursor: pointer;
            border: none;
            background: transparent;
            font-weight: 700;
            color: #0f172a;
        }
        .agent-header-meta {
            float: right;
            color: #6b7280;
            font-weight: 500;
        }
    </style>

<body class="nk-body bg-light has-sidebar">
    <!-- Top Navigation -->
   <?php include_once('includes/head.php'); ?>

    <!-- Sidebar -->
   <?php include_once('includes/sidebar.php'); ?>

    <!-- Main Content -->
    <div class="nk-wrap">
        <div class="nk-content">
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="nk-block-head">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Transactions & Bets Monitoring</h3>
                            <div class="nk-block-des text-soft">
                                <p>Real-time monitoring of all bets and transactions across all agents</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <button class="export-btn" onclick="exportToExcel()">
                                <i class="fas fa-file-excel me-2"></i>Export to Excel
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Daily Summary Metrics -->
                <div class="nk-block">
                    <div class="row g-gs">
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card revenue">
                                <div class="metric-icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                                <div id="metricRevenue" class="metric-value">₦ 0.00</div>
                                <div class="metric-label">Today's Revenue</div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card bets">
                                <div class="metric-icon">
                                    <i class="fas fa-ticket-alt"></i>
                                </div>
                                <div id="metricBets" class="metric-value">0</div>
                                <div class="metric-label">Total Bets Today</div>
                            </div>
                        </div>
                        <!-- Only two metrics shown: Revenue and Total Bets (real-time) -->
                    </div>
                </div>

                <!-- Filters Section -->
                <div class="filter-section">
                    <h6 class="section-title">
                        <i class="fas fa-filter"></i>
                        Filter Transactions
                    </h6>
                    <div class="filter-group">
                        <div class="filter-item">
                            <label class="form-label">Date Range</label>
                            <input type="date" class="form-control" id="dateFilter" value="2024-11-10">
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Agent</label>
                            <select class="form-select" id="agentFilter">
                                <option value="">All Agents</option>
                                <option value="A2876">John Smith (#A2876)</option>
                                <option value="A2875">Sarah Wilson (#A2875)</option>
                                <option value="A2874">Mike Johnson (#A2874)</option>
                            </select>
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Game Type</label>
                            <select class="form-select" id="gameFilter">
                                <option value="">All Games</option>
                                <option value="5/90">5/90</option>
                                <option value="6/90">6/90</option>
                            </select>
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Status</label>
                            <select class="form-select" id="statusFilter">
                                <option value="">All Status</option>
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="processing">Processing</option>
                            </select>
                        </div>
                        <div class="filter-item">
                            <button class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-search me-2"></i>Apply Filters
                            </button>
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Search</label>
                            <input type="search" id="transactionsSearch" class="form-control" placeholder="Search tickets, agents, players..." oninput="onSearchInput()">
                        </div>
                    </div>
                </div>

                <!-- Transactions Table -->
                <div class="admin-section">
                    <div class="card-title-group">
                        <div class="card-title">
                            <h6 class="title">All Transactions & Bets</h6>
                        </div>
                        <div class="card-tools">
                            <span class="text-muted">Showing 1-50 of 9,158 transactions</span>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Transaction ID</th>
                                    <th>Agent</th>
                                    <th>Player</th>
                                    <th>Game Type</th>
                                    <th>Bet Numbers</th>
                                    <th>Amount</th>
                                    <th>Timestamp</th>
                                    <th>Draw</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="transactionsTableBody">
                                <!-- Rows will be populated dynamically: grouped by agent with their tickets -->
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="pagination">
                        <div class="page-item active">1</div>
                        <div class="page-item">2</div>
                        <div class="page-item">3</div>
                        <div class="page-item">...</div>
                        <div class="page-item">184</div>
                    </div>
                </div>

                <!-- Summary Statistics -->
                <div class="row g-gs">
                    <div class="col-lg-12">
                        <div class="admin-section">
                            <h6 class="section-title">
                                <i class="fas fa-chart-bar"></i>
                                Revenue by Agent (Today)
                            </h6>
                            <div id="revenueByAgent" class="quick-stats">
                                <!-- Revenue per agent will be rendered here by JS -->
                                <div class="stat-row">
                                    <span>Loading...</span>
                                    <span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="/blueextra/public/assets/js/bundle9b70.js?ver=3.3.0"></script>
    <script src="/blueextra/public/assets/js/scripts9b70.js?ver=3.3.0"></script>

    <script>
        // Transactions and Bets Management
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize real-time updates
            initializeTransactionMonitoring();
        });

        function initializeTransactionMonitoring() {
            // Simulate real-time transaction updates
            setInterval(() => {
                updateLiveTransactions();
                updateMetrics();
                updateRevenueByAgent();
            }, 10000); // Update every 10 seconds
        }

        function updateLiveTransactions() {
            // In real implementation, this would fetch from transactions API
            console.log('Updating live transactions data...');
            
            // Update counters and refresh data
            const timestamp = new Date().toLocaleTimeString();
            console.log(`Last updated: ${timestamp}`);
        }

        // Update the summary metric values from the cached tickets
        function updateMetrics() {
            const tickets = window.ticketsCache || [];
            // Revenue: sum of stake/amount
            let totalRevenue = 0;
            tickets.forEach(t => { totalRevenue += parseFloat(t.stake || t.amount || 0) || 0; });
            const totalBets = tickets.length || 0;

            const revEl = document.getElementById('metricRevenue');
            const betsEl = document.getElementById('metricBets');
            if (revEl) revEl.textContent = formatCurrency(totalRevenue);
            if (betsEl) betsEl.textContent = totalBets.toLocaleString();
        }

        // Compute and render revenue by agent for TODAY using tickets cache
        function updateRevenueByAgent() {
            const tickets = window.ticketsCache || [];
            const agents = window.agentsCache || [];
            const agentMap = {};
            agents.forEach(a => { agentMap[a.id || a.agent_id || a.agentId] = a; });

            // helper to check same day (local) between ticket timestamp and today
            function isToday(ts) {
                if (!ts) return false;
                const d = new Date(ts);
                if (isNaN(d.getTime())) return false;
                const now = new Date();
                return d.getFullYear() === now.getFullYear() && d.getMonth() === now.getMonth() && d.getDate() === now.getDate();
            }

            const revenueByAgent = {}; // agentId => sum
            tickets.forEach(t => {
                const timestamp = t.purchased_at || t.created_at || t.createdAt || t.created;
                if (!isToday(timestamp)) return; // only today's tickets
                const aid = t.agent_id || t.agentId || t.agent || 'unknown';
                const amt = parseFloat(t.stake || t.amount || 0) || 0;
                revenueByAgent[aid] = (revenueByAgent[aid] || 0) + amt;
            });

            // convert to array and sort desc
            const rows = Object.keys(revenueByAgent).map(aid => ({ aid, revenue: revenueByAgent[aid] }));
            rows.sort((a,b) => b.revenue - a.revenue);

            const container = document.getElementById('revenueByAgent');
            if (!container) return;
            if (rows.length === 0) {
                container.innerHTML = '<div class="stat-row"><span>No revenue data for today</span><span></span></div>';
                return;
            }

            // render top agents and an "Other Agents" aggregate if needed
            const maxShown = 8;
            let html = '';
            let shownTotal = 0;
            for (let i = 0; i < Math.min(rows.length, maxShown); i++) {
                const r = rows[i];
                shownTotal += r.revenue;
                const agent = agentMap[r.aid] || null;
                const name = agent ? ((agent.first_name || agent.firstName) ? ((agent.first_name||agent.firstName) + ' ' + (agent.last_name||agent.lastName||'')) : (agent.username || agent.agent_id || agent.agentId)) : ('Agent #' + r.aid);
                html += `<div class="stat-row"><span>${escapeHtml(name)} (${escapeHtml(String(r.aid))}):</span><span>${formatCurrency(r.revenue)}</span></div>`;
            }
            if (rows.length > maxShown) {
                let otherTotal = 0;
                for (let i = maxShown; i < rows.length; i++) otherTotal += rows[i].revenue;
                html += `<div class="stat-row"><span>Other Agents:</span><span>${formatCurrency(otherTotal)}</span></div>`;
            }

            container.innerHTML = html;
        }

        function applyFilters() {
            const date = document.getElementById('dateFilter').value;
            const agent = document.getElementById('agentFilter').value;
            const game = document.getElementById('gameFilter').value;
            const status = document.getElementById('statusFilter').value;
            // Update client-side filters and re-render
            window.transactionsCurrentPage = 1;
            filteredTickets = filterTickets();
            renderTransactions();
        }

        function viewTransaction(transactionId) {
            console.log('Viewing transaction:', transactionId);
            // In real implementation, this would open a modal or navigate to transaction details
            alert(`Viewing transaction details for: ${transactionId}`);
        }

        function exportToExcel() {
            console.log('Exporting transactions to Excel...');
            // In real implementation, this would generate and download Excel file
            alert('Exporting transactions data to Excel file...');
        }

        // Real-time notification for new transactions
        function simulateNewTransaction() {
            // This would be called by WebSocket or real-time API
            console.log('New transaction received - updating display...');
        }

        // Load agents and tickets, group tickets by agent, and render into the table
        document.addEventListener('DOMContentLoaded', function() {
            loadAgentsAndTickets();
        });

        async function loadAgentsAndTickets() {
            const base = '/blueextra/api';
            const tableBody = document.getElementById('transactionsTableBody');
            if (!tableBody) return;

            try {
                // Fetch agents list
                const agentsResp = await fetch(base + '/agent/list');
                const agentsJson = await agentsResp.json();
                const agents = (agentsJson && agentsJson.state) ? agentsJson.message : [];

                // Fetch tickets list
                const ticketsResp = await fetch(base + '/ticket/list');
                const ticketsJson = await ticketsResp.json();
                const tickets = (ticketsJson && ticketsJson.state) ? ticketsJson.message : [];

                // Build map of agentId => agent object
                const agentMap = {};
                (agents || []).forEach(a => {
                    // agent model may use 'id' as PK
                    agentMap[a.id || a.agent_id || a.agentId || a.agentId] = a;
                });

                // Group tickets by agent_id
                const grouped = {};
                (tickets || []).forEach(t => {
                    const aid = t.agent_id || t.agentId || t.agentId || 'unknown';
                    if (!grouped[aid]) grouped[aid] = [];
                    grouped[aid].push(t);
                });

                // store caches and initialize pagination/search
                window.agentsCache = agents || [];
                window.ticketsCache = tickets || [];
                window.transactionsPerPage = 20;
                window.transactionsCurrentPage = 1;
                tableBody.innerHTML = '';

                // initialize filteredTickets and render
                filteredTickets = filterTickets();
                renderTransactions();
                // update metric summary immediately after initial render
                updateMetrics();
                // populate revenue-by-agent immediately from client cache
                updateRevenueByAgent();

                

            } catch (err) {
                console.error('Failed to load agents or tickets', err);
                alert('Failed to load transactions data. See console for details.');
            }
        }

        // Client-side caches and state
        let filteredTickets = [];

        function onSearchInput() {
            window.transactionsCurrentPage = 1;
            filteredTickets = filterTickets();
            renderTransactions();
        }

        function filterTickets() {
            const search = (document.getElementById('transactionsSearch')?.value || '').toLowerCase().trim();
            const agentFilterVal = (document.getElementById('agentFilter')?.value || '').trim();
            const gameFilterVal = (document.getElementById('gameFilter')?.value || '').trim();

            const tickets = window.ticketsCache || [];
            const agents = window.agentsCache || [];
            const agentNameById = {};
            agents.forEach(a => { agentNameById[a.id || a.agent_id || a.agentId] = (a.first_name ? a.first_name + ' ' + (a.last_name||'') : (a.username || '')); });

            return tickets.filter(t => {
                // agent filter
                if (agentFilterVal) {
                    const aid = String(t.agent_id || t.agentId || t.agent || '');
                    if (!aid.includes(agentFilterVal) && !(agentNameById[aid]||'').toLowerCase().includes(agentFilterVal.toLowerCase())) return false;
                }
                // game filter
                if (gameFilterVal) {
                    const g = (t.game || t.game_type || t.gameType || '').toString();
                    if (!g.includes(gameFilterVal)) return false;
                }
                // search
                if (search) {
                    const ticketSerial = (t.ticket_serial || t.ticketSerial || t.id || '').toString().toLowerCase();
                    const player = (t.player_name || t.player || t.customer_name || t.customer || '').toString().toLowerCase();
                    const agentName = (agentNameById[t.agent_id] || agentNameById[t.agentId] || '').toString().toLowerCase();
                    const numbers = Array.isArray(t.numbers_selected) ? t.numbers_selected.join(' ') : (typeof t.numbers_selected === 'string' ? t.numbers_selected : '');
                    const game = (t.game || t.game_type || t.gameType || '').toString().toLowerCase();
                    if (ticketSerial.includes(search) || player.includes(search) || agentName.includes(search) || String(numbers).toLowerCase().includes(search) || game.includes(search)) return true;
                    return false;
                }
                return true;
            });
        }

        function renderTransactions() {
            // recompute grouped page rendering
            const tableBody = document.getElementById('transactionsTableBody');
            if (!tableBody) return;
            // update filteredTickets if empty
            if (!Array.isArray(filteredTickets)) filteredTickets = filterTickets();
            // render as done in loadAgentsAndTickets by reusing agentMap and grouping
            // reuse agentMap
            const agents = window.agentsCache || [];
            const agentMap = {};
            agents.forEach(a => { agentMap[a.id || a.agent_id || a.agentId] = a; });

            // clear
            tableBody.innerHTML = '';

            // apply pagination and grouping then render
            const perPage = window.transactionsPerPage || 20;
            const currentPage = window.transactionsCurrentPage || 1;
            const start = (currentPage - 1) * perPage;
            const end = start + perPage;
            const pageTickets = filteredTickets.slice(start, end);
            const pageGrouped = {};
            pageTickets.forEach(t => {
                const aid = t.agent_id || t.agentId || t.agent || 'unknown';
                if (!pageGrouped[aid]) pageGrouped[aid] = [];
                pageGrouped[aid].push(t);
            });

            for (const aid of Object.keys(pageGrouped)) {
                const agent = agentMap[aid] || null;
                const agentNameRaw = agent ? ((agent.first_name || agent.firstName ? ((agent.first_name||agent.firstName) + ' ' + (agent.last_name||agent.lastName||'')) : (agent.username || agent.agent_id || agent.agentId))) : ('Agent #' + aid);
                const agentName = agentNameRaw || ('Agent #' + aid);

                let totalStake = 0;
                (pageGrouped[aid] || []).forEach(t => { totalStake += parseFloat(t.stake || t.amount || 0) || 0; });

                const hdr = document.createElement('tr');
                hdr.className = 'agent-header-row';
                hdr.innerHTML = `<td colspan="9">` +
                    `<button class="agent-toggle" data-agent="${escapeHtml(aid)}">▾</button> ` +
                    `${escapeHtml(agentName)}` +
                    `<span class="agent-header-meta">${pageGrouped[aid].length} tickets • ${formatCurrency(totalStake)}</span>` +
                    `</td>`;
                tableBody.appendChild(hdr);

                pageGrouped[aid].forEach(ticket => {
                    const row = document.createElement('tr');
                    row.setAttribute('data-agent', aid);
                    const ticketSerial = ticket.ticket_serial || ticket.ticketSerial || ticket.id || '';
                    const player = ticket.player_name || ticket.player || (ticket.customer_name || ticket.customer || '-') ;
                    const gameType = ticket.game || ticket.game_type || ticket.gameType || '';
                    const numbers = Array.isArray(ticket.numbers_selected) ? ticket.numbers_selected : (typeof ticket.numbers_selected === 'string' ? tryParseJson(ticket.numbers_selected) || [] : []);
                    const numbersHtml = numbers.map(n => `<span class="winning-number">${escapeHtml(String(n).padStart(2,'0'))}</span>`).join('');
                    const stakeVal = parseFloat(ticket.stake || ticket.amount || 0) || 0;
                    const prizeVal = parseFloat(ticket.prize_amount || 0) || 0;
                    let amountHtml = '';
                    let amountClass = 'amount-negative';
                    if (prizeVal > 0) { amountClass = 'amount-positive'; amountHtml = `+ ${formatCurrency(prizeVal)}`; }
                    else { amountClass = 'amount-negative'; amountHtml = `- ${formatCurrency(stakeVal)}`; }
                    const timestamp = ticket.purchased_at || ticket.created_at || ticket.createdAt || '';
                    const draw = ticket.draw_id || ticket.drawId || ticket.draw || '';

                    row.innerHTML = `
                        <td><strong>#${escapeHtml(ticketSerial)}</strong></td>
                        <td>${escapeHtml(agentName)}<br><small class="text-muted">#${escapeHtml(aid)}</small></td>
                        <td>${escapeHtml(player)}</td>
                        <td><span class="bet-type-badge">${escapeHtml(gameType)}</span></td>
                        <td><div class="winning-numbers">${numbersHtml}</div></td>
                        <td class="${amountClass}">${amountHtml}</td>
                        <td>${formatDate(timestamp)}</td>
                        <td>${escapeHtml(draw ? '#'+draw : '')}</td>
                        <td><button class="btn btn-sm btn-outline-primary" onclick="viewTransaction('${escapeJs(ticketSerial)}')"><i class="fas fa-eye"></i></button></td>
                    `;
                    tableBody.appendChild(row);
                });

                const toggleBtn = hdr.querySelector('.agent-toggle');
                if (toggleBtn) {
                    toggleBtn.addEventListener('click', (e) => {
                        const id = toggleBtn.getAttribute('data-agent');
                        const rows = tableBody.querySelectorAll(`tr[data-agent="${id}"]`);
                        const isVisible = rows.length && rows[0].style.display !== 'none';
                        rows.forEach(r => r.style.display = isVisible ? 'none' : '');
                        toggleBtn.textContent = isVisible ? '▸' : '▾';
                    });
                }
            }

            renderTransactionsPagination(filteredTickets.length, window.transactionsPerPage || 20, window.transactionsCurrentPage || 1);
        }

        function tryParseJson(str) {
            try { return JSON.parse(str); } catch(e) { return null; }
        }

        function formatDate(val) {
            if (!val) return '';
            const d = new Date(val);
            if (isNaN(d.getTime())) return escapeHtml(val);
            // return HTML string (safe because we control formatting)
            return d.toLocaleDateString() + '<br><small>' + d.toLocaleTimeString() + '</small>';
        }

        function formatCurrency(n) {
            const v = Number(n) || 0;
            return '₦ ' + v.toFixed(2);
        }

        function escapeHtml(s) {
            if (s === null || s === undefined) return '';
            return String(s).replace(/[&<>"']/g, function(c) { return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":"&#39;"}[c]; });
        }

        function escapeJs(s) {
            if (s === null || s === undefined) return '';
            return String(s).replace(/'/g, "\\'");
        }

        function renderTransactionsPagination(totalItems, perPage, currentPage) {
            const paginationEl = document.querySelector('.pagination');
            if (!paginationEl) return;
            const totalPages = Math.max(1, Math.ceil(totalItems / perPage));
            // clamp currentPage
            currentPage = Math.min(Math.max(1, currentPage), totalPages);
            window.transactionsCurrentPage = currentPage;
            // build simple pagination (prev, pages, next)
            let html = '';
            const prevClass = (currentPage === 1) ? 'page-item disabled' : 'page-item';
            html += `<div class="${prevClass}" data-page="${currentPage-1}">Prev</div>`;
            // show up to 7 pages centered
            const maxButtons = 7;
            let start = Math.max(1, currentPage - Math.floor(maxButtons/2));
            let end = Math.min(totalPages, start + maxButtons - 1);
            if (end - start + 1 < maxButtons) start = Math.max(1, end - maxButtons + 1);
            for (let p = start; p <= end; p++) {
                const cls = (p === currentPage) ? 'page-item active' : 'page-item';
                html += `<div class="${cls}" data-page="${p}">${p}</div>`;
            }
            const nextClass = (currentPage === totalPages) ? 'page-item disabled' : 'page-item';
            html += `<div class="${nextClass}" data-page="${currentPage+1}">Next</div>`;
            paginationEl.innerHTML = html;
            // attach events
            paginationEl.querySelectorAll('.page-item').forEach(el => {
                if (el.classList.contains('disabled')) return;
                el.addEventListener('click', () => {
                    const p = parseInt(el.getAttribute('data-page')) || 1;
                    window.transactionsCurrentPage = p;
                    renderTransactions();
                });
            });
        }
    </script>
</body>
</html>