<?php include_once('includes/head.php'); ?>
    <style>
        .agent-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border: 1px solid #e3ebf6;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 340px; /* normalize card heights */
        }
        .agent-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .agent-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        .agent-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.2rem;
            margin-right: 15px;
        }
        .agent-info {
            flex: 1;
        }
        .agent-name {
            font-size: 1.2rem;
            font-weight: 700;
            color: #1e293b;
            margin: 0;
        }
        .agent-id {
            color: #64748b;
            font-size: 0.9rem;
            margin: 2px 0;
        }
        .agent-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin: 15px 0;
        }
        .stat-item {
            text-align: center;
            padding: 10px;
            background: #f8fafc;
            border-radius: 8px;
        }
        .stat-value {
            font-size: 1.1rem;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 2px;
        }
        .stat-label {
            font-size: 0.8rem;
            color: #64748b;
        }
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        .status-active { background: #d1fae5; color: #065f46; }
        .status-inactive { background: #fee2e2; color: #991b1b; }
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-suspended { background: #e5e7eb; color: #374151; }
        
        .action-buttons {
            display: flex;
            gap: 8px;
            margin-top: 15px;
            align-items: center;
            justify-content: flex-end;
            flex-wrap: wrap;
        }
        .btn-sm {
            padding: 6px 12px;
            font-size: 0.8rem;
        }

        .agent-contact {
            margin-top: 10px;
            display: flex;
            flex-direction: column;
            gap: 6px;
        }

        /* make the small status select compact and align with buttons */
        .action-buttons .form-select-sm {
            display: inline-block;
            vertical-align: middle;
            padding: .25rem .5rem;
            height: calc(1.5em + .5rem);
            min-width: 120px;
        }
        
        .search-controls {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid #e3ebf6;
        }
        .search-box {
            position: relative;
        }
        .search-box .form-control {
            padding-left: 45px;
        }
        .search-box i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
        }
        
        .filter-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }
        .filter-tab {
            padding: 8px 16px;
            border: 1px solid #e3ebf6;
            border-radius: 20px;
            background: white;
            color: #64748b;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .filter-tab.active {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        .filter-tab:hover {
            border-color: #667eea;
            color: #667eea;
        }
        .filter-tab.active:hover {
            color: white;
        }
        
        .pagination-container {
            background: white;
            border-radius: 10px;
            padding: 15px 20px;
            margin-top: 20px;
            border: 1px solid #e3ebf6;
        }
        
        .create-agent-btn {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .create-agent-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.4);
        }
        
        .modal-lg-custom {
            max-width: 700px;
        }
        .form-section {
            background: #f8fafc;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .section-title i {
            color: #667eea;
        }
    </style>

<body class="nk-body bg-light has-sidebar">
    <!-- Top Navigation -->
   <?php include_once('includes/head.php'); ?>

    <!-- Sidebar -->
   <?php include_once('includes/sidebar.php'); ?>

    <!-- Main Content -->
    <div class="nk-wrap">
        <div class="nk-content">
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="nk-block-head">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Agent Management</h3>
                            <div class="nk-block-des text-soft">
                                <p>Manage all lottery agents and their accounts</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <button class="btn create-agent-btn" data-bs-toggle="modal" data-bs-target="#createAgentModal">
                                <i class="fas fa-user-plus me-2"></i>Create New Agent
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Search and Filter Controls -->
                <div class="search-controls">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="search-box">
                                <i class="fas fa-search"></i>
                                <input type="text" class="form-control" id="searchAgents" placeholder="Search agents by name, ID, or location...">
                            </div>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="text-muted" id="agentsCount">
                                Loading agents...
                            </div>
                        </div>
                    </div>
                    
                    <!-- Filter Tabs -->
                    <div class="filter-tabs">
                        <a href="#" class="filter-tab active" data-filter="all">All Agents</a>
                        <a href="#" class="filter-tab" data-filter="active">Active</a>
                        <a href="#" class="filter-tab" data-filter="inactive">Inactive</a>
                        <a href="#" class="filter-tab" data-filter="pending">Pending</a>
                        <a href="#" class="filter-tab" data-filter="suspended">Suspended</a>
                    </div>
                </div>

                <!-- Agents Grid -->
                <div class="nk-block">
                    <div class="row" id="agentsGrid">
                        <!-- Agents will be populated by JavaScript -->
                    </div>
                </div>

                <!-- Pagination -->
                <div class="pagination-container">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="text-muted" id="paginationInfo">
                                Showing 0 of 0 agents
                            </div>
                        </div>
                        <div class="col-md-6">
                            <nav aria-label="Agents navigation">
                                <ul class="pagination justify-content-end mb-0" id="pagination">
                                    <!-- Pagination will be generated by JavaScript -->
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Agent Modal -->
    <div class="modal fade" id="createAgentModal" tabindex="-1" aria-labelledby="createAgentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createAgentModalLabel">Create New Agent</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="createAgentForm">
                        <!-- Personal Information -->
                        <div class="form-section">
                            <h6 class="section-title">
                                <i class="fas fa-user"></i>
                                Personal Information
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">First Name *</label>
                                        <input type="text" class="form-control" id="firstName" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Last Name *</label>
                                        <input type="text" class="form-control" id="lastName" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Email Address *</label>
                                        <input type="email" class="form-control" id="email" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Phone Number *</label>
                                        <input type="tel" class="form-control" id="phone" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Date of Birth</label>
                                        <input type="date" class="form-control" id="dob">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Gender</label>
                                        <select class="form-select" id="gender">
                                            <option value="">Select Gender</option>
                                            <option value="male">Male</option>
                                            <option value="female">Female</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Contact Information -->
                        <div class="form-section">
                            <h6 class="section-title">
                                <i class="fas fa-address-book"></i>
                                Contact Information
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Address *</label>
                                        <input type="text" class="form-control" id="address" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">City *</label>
                                        <input type="text" class="form-control" id="city" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">State *</label>
                                        <input type="text" class="form-control" id="state" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">ZIP Code</label>
                                        <input type="text" class="form-control" id="zipCode">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Location Description</label>
                                        <textarea class="form-control" id="locationDescription" rows="2" placeholder="Landmarks or additional location details"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Agent Account Settings -->
                        <div class="form-section">
                            <h6 class="section-title">
                                <i class="fas fa-cog"></i>
                                Account Settings
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Agent ID *</label>
                                        <input type="text" class="form-control" id="agentId" required>
                                        <small class="form-text text-muted">Unique identifier for the agent</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Hidden initial credit limit: use default value instead of showing to user -->
                                    <input type="hidden" id="creditLimit" value="5000">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <!-- Hidden commission rate: use default value instead of showing to user -->
                                        <input type="hidden" id="commissionRate" value="5">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Account Status</label>
                                        <select class="form-select" id="accountStatus">
                                            <option value="active">Active</option>
                                            <option value="pending">Pending</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Notes & Comments</label>
                                        <textarea class="form-control" id="agentNotes" rows="3" placeholder="Any additional information about this agent..."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Login Credentials -->
                        <div class="form-section">
                            <h6 class="section-title">
                                <i class="fas fa-key"></i>
                                Login Credentials
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Username *</label>
                                        <input type="text" class="form-control" id="username" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Temporary Password *</label>
                                        <input type="password" class="form-control" id="tempPassword" required>
                                        <small class="form-text text-muted">Agent will be prompted to change this on first login</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="createAgent()">
                        <i class="fas fa-save me-2"></i>Create Agent
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="/loto/public/assets/js/bundle9b70.js?ver=3.3.0"></script>
    <script src="/loto/public/assets/js/scripts9b70.js?ver=3.3.0"></script>
    <!-- Axios for AJAX calls -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script>
        // Local fallback for setBusy used by other pages.
        // If a global setBusy exists, defer to it. Otherwise create a minimal overlay.
        (function() {
            if (typeof window.setBusy !== 'undefined') return; // global already present

            // Create overlay element lazily
            function ensureOverlay() {
                let o = document.getElementById('globalBusyOverlay');
                if (!o) {
                    o = document.createElement('div');
                    o.id = 'globalBusyOverlay';
                    o.style.position = 'fixed';
                    o.style.top = '0';
                    o.style.left = '0';
                    o.style.width = '100%';
                    o.style.height = '100%';
                    o.style.display = 'none';
                    o.style.alignItems = 'center';
                    o.style.justifyContent = 'center';
                    o.style.zIndex = '20000';
                    o.style.background = 'rgba(0,0,0,0.35)';

                    const box = document.createElement('div');
                    box.style.padding = '18px 22px';
                    box.style.background = '#fff';
                    box.style.borderRadius = '8px';
                    box.style.boxShadow = '0 6px 20px rgba(0,0,0,0.2)';
                    box.style.display = 'flex';
                    box.style.alignItems = 'center';
                    box.style.gap = '12px';

                    const spinner = document.createElement('div');
                    spinner.className = 'spinner-border text-primary';
                    spinner.role = 'status';
                    spinner.style.width = '1.5rem';
                    spinner.style.height = '1.5rem';

                    const msg = document.createElement('div');
                    msg.className = 'busy-message';
                    msg.style.fontSize = '0.95rem';
                    msg.style.color = '#111';
                    msg.textContent = 'Loading...';

                    box.appendChild(spinner);
                    box.appendChild(msg);
                    o.appendChild(box);
                    document.body.appendChild(o);
                }
                return o;
            }

            window.setBusy = function(isBusy, message) {
                // If a global legacy loader exists under another name, try to call it
                if (typeof window.setBusyGlobal === 'function') {
                    try { window.setBusyGlobal(isBusy, message); return; } catch(e) { /* fallthrough */ }
                }

                const ov = ensureOverlay();
                const msgEl = ov.querySelector('.busy-message');
                if (msgEl && message) msgEl.textContent = message;
                ov.style.display = isBusy ? 'flex' : 'none';
            };
        })();

        // Agents data will be fetched from the API
        let sampleAgents = [];

        let currentPage = 1;
        const itemsPerPage = 12;
        let filteredAgents = [...sampleAgents];
        let currentFilter = 'all';

        // Initialize the page
        document.addEventListener('DOMContentLoaded', function() {
            setupEventListeners();
            fetchAgents();
        });

        // Fetch agents from backend
        async function fetchAgents() {
            try {
                setBusy(true, 'Loading agents...');
                const res = await axios.get('/loto/api/agent/list', { withCredentials: true });
                // Normalize response shapes
                const data = res.data && (res.data.data || res.data.message || res.data) || [];
                sampleAgents = Array.isArray(data) ? data : (data.items || []);
                // Ensure we have the fields used in UI (provide safe defaults)
                sampleAgents = sampleAgents.map(a => ({
                    id: String(a.id ?? a.agent_id ?? a.agentId ?? a.agentID ?? a.agent ?? ''),
                    firstName: (a.first_name || a.firstName || a.firstname || (a.name ? a.name.split(' ')[0] : '') || '').toString(),
                    lastName: (a.last_name || a.lastName || a.lastname || (a.name ? a.name.split(' ').slice(1).join(' ') : '') || '').toString(),
                    email: a.email || '',
                    phone: a.phone || a.mobile || '',
                    status: a.status || 'active',
                    creditLimit: a.credit_limit || a.creditLimit || 0,
                    currentBalance: a.current_balance || a.currentBalance || 0,
                    commissionRate: a.commission_rate || a.commissionRate || 0,
                    totalBets: a.total_bets || a.totalBets || 0,
                    totalCommission: a.total_commission || a.totalCommission || 0,
                    location: a.location || a.city || '',
                    joinDate: a.join_date || a.joinDate || '',
                    lastActive: a.last_active || a.lastActive || ''
                }));

                filteredAgents = [...sampleAgents];
                currentPage = 1;
                renderAgents();
            } catch (err) {
                console.error('Failed to load agents', err);
                alert('Could not load agents from server. Check console for details.');
            } finally {
                setBusy(false);
            }
        }

        // Render agents grid
        function renderAgents() {
            const grid = document.getElementById('agentsGrid');
            const startIndex = (currentPage - 1) * itemsPerPage;
            const endIndex = startIndex + itemsPerPage;
            const pageData = filteredAgents.slice(startIndex, endIndex);

            grid.innerHTML = '';

            if (pageData.length === 0) {
                grid.innerHTML = `
                    <div class="col-12">
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-3x text-muted mb-3"></i>
                            <h4>No Agents Found</h4>
                            <p class="text-muted">No agents match your current filters.</p>
                            <button class="btn btn-primary mt-3" onclick="clearFilters()">
                                <i class="fas fa-refresh me-2"></i>Clear Filters
                            </button>
                        </div>
                    </div>
                `;
            } else {
                pageData.forEach(agent => {
                    const card = createAgentCard(agent);
                    grid.appendChild(card);
                });
            }

            updatePagination();
            updateAgentsCount();
        }

        // Create agent card
        function createAgentCard(agent) {
            const col = document.createElement('div');
            col.className = 'col-lg-4 col-md-6';
            
            const statusClass = `status-${agent.status}`;
            const statusText = (agent.status || '').charAt(0).toUpperCase() + (agent.status || '').slice(1);
            const initials = `${(agent.firstName||'')[0] || ''}${(agent.lastName||'')[0] || ''}`.toUpperCase();
            
            col.innerHTML = `
                <div class="agent-card">
                    <div class="agent-header">
                        <div class="agent-avatar">${initials}</div>
                        <div class="agent-info">
                            <h5 class="agent-name">${agent.firstName} ${agent.lastName}</h5>
                            <div class="agent-id">${agent.id}</div>
                            <div class="agent-location text-muted small">
                                <i class="fas fa-map-marker-alt me-1"></i>${agent.location}
                            </div>
                        </div>
                        <span class="status-badge ${statusClass}">${statusText}</span>
                    </div>
                    
                   
                    
                    <div class="agent-contact">
                        <div class="small text-muted mb-2">
                            <i class="fas fa-phone me-1"></i>${agent.phone}
                        </div>
                        <div class="small text-muted">
                            <i class="fas fa-envelope me-1"></i>${agent.email}
                        </div>
                    </div>
                    
                    <div class="action-buttons">
                        <button class="btn btn-sm btn-primary" onclick="viewAgent('${agent.id}')">
                            <i class="fas fa-eye"></i> View
                        </button>
                        <button class="btn btn-sm btn-outline-secondary" onclick="editAgent('${agent.id}')">
                            <i class="fas fa-edit"></i> Edit
                        </button>
                        ${agent.status === 'active' ? `
                        <button class="btn btn-sm btn-outline-warning" onclick="suspendAgent('${agent.id}')">
                            <i class="fas fa-pause"></i> Suspend
                        </button>
                        ` : ''}
                        ${agent.status === 'suspended' ? `
                        <button class="btn btn-sm btn-outline-success" onclick="activateAgent('${agent.id}')">
                            <i class="fas fa-play"></i> Activate
                        </button>
                        ` : ''}
                        <!-- Quick status selector -->
                        <select class="form-select form-select-sm" style="width:140px;" onchange="changeAgentStatus('${agent.id}', this.value)">
                            <option value="active" ${agent.status === 'active' ? 'selected' : ''}>Active</option>
                            <option value="pending" ${agent.status === 'pending' ? 'selected' : ''}>Pending</option>
                            <option value="inactive" ${agent.status === 'inactive' ? 'selected' : ''}>Inactive</option>
                            <option value="suspended" ${agent.status === 'suspended' ? 'selected' : ''}>Suspended</option>
                        </select>

                        <button class="btn btn-sm btn-outline-danger" onclick="deleteAgent('${agent.id}')">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </div>
                </div>
            `;
            
            return col;
        }

        // Setup event listeners
        function setupEventListeners() {
            // Search
            document.getElementById('searchAgents').addEventListener('input', function() {
                filterAgents();
            });
            
            // Filter tabs
            document.querySelectorAll('.filter-tab').forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Update active tab
                    document.querySelectorAll('.filter-tab').forEach(t => t.classList.remove('active'));
                    this.classList.add('active');
                    
                    currentFilter = this.getAttribute('data-filter');
                    filterAgents();
                });
            });
        }

        // Filter agents
        function filterAgents() {
            const searchTerm = document.getElementById('searchAgents').value.toLowerCase();
            
            filteredAgents = sampleAgents.filter(agent => {
                const matchesSearch = !searchTerm || 
                    agent.firstName.toLowerCase().includes(searchTerm) ||
                    agent.lastName.toLowerCase().includes(searchTerm) ||
                    agent.id.toLowerCase().includes(searchTerm) ||
                    agent.location.toLowerCase().includes(searchTerm) ||
                    agent.email.toLowerCase().includes(searchTerm);
                
                const matchesFilter = currentFilter === 'all' || agent.status === currentFilter;
                
                return matchesSearch && matchesFilter;
            });
            
            currentPage = 1;
            renderAgents();
        }

        // Clear filters
        function clearFilters() {
            document.getElementById('searchAgents').value = '';
            document.querySelectorAll('.filter-tab').forEach(t => t.classList.remove('active'));
            document.querySelector('[data-filter="all"]').classList.add('active');
            currentFilter = 'all';
            filterAgents();
        }

        // Update pagination
        function updatePagination() {
            const totalPages = Math.ceil(filteredAgents.length / itemsPerPage);
            const pagination = document.getElementById('pagination');
            const paginationInfo = document.getElementById('paginationInfo');
            
            const startItem = (currentPage - 1) * itemsPerPage + 1;
            const endItem = Math.min(currentPage * itemsPerPage, filteredAgents.length);
            
            paginationInfo.textContent = `Showing ${startItem} to ${endItem} of ${filteredAgents.length} agents`;
            
            pagination.innerHTML = '';
            
            // Previous button
            const prevLi = document.createElement('li');
            prevLi.className = `page-item ${currentPage === 1 ? 'disabled' : ''}`;
            prevLi.innerHTML = `<a class="page-link" href="#" onclick="changePage(${currentPage - 1})">Previous</a>`;
            pagination.appendChild(prevLi);
            
            // Page numbers
            const maxPages = 5;
            let startPage = Math.max(1, currentPage - Math.floor(maxPages / 2));
            let endPage = Math.min(totalPages, startPage + maxPages - 1);
            
            if (endPage - startPage + 1 < maxPages) {
                startPage = Math.max(1, endPage - maxPages + 1);
            }
            
            for (let i = startPage; i <= endPage; i++) {
                const li = document.createElement('li');
                li.className = `page-item ${i === currentPage ? 'active' : ''}`;
                li.innerHTML = `<a class="page-link" href="#" onclick="changePage(${i})">${i}</a>`;
                pagination.appendChild(li);
            }
            
            // Next button
            const nextLi = document.createElement('li');
            nextLi.className = `page-item ${currentPage === totalPages ? 'disabled' : ''}`;
            nextLi.innerHTML = `<a class="page-link" href="#" onclick="changePage(${currentPage + 1})">Next</a>`;
            pagination.appendChild(nextLi);
        }

        // Update agents count
        function updateAgentsCount() {
            const totalAgents = sampleAgents.length;
            const filteredCount = filteredAgents.length;
            
            let countText = `${filteredCount} agents`;
            if (filteredCount !== totalAgents) {
                countText += ` (filtered from ${totalAgents} total)`;
            }
            
            document.getElementById('agentsCount').textContent = countText;
        }

        // Change page
        function changePage(page) {
            const totalPages = Math.ceil(filteredAgents.length / itemsPerPage);
            if (page >= 1 && page <= totalPages) {
                currentPage = page;
                renderAgents();
            }
        }

        // Editing state
        let editingAgentId = null;

        // Create or update agent
        async function createAgent() {
            const form = document.getElementById('createAgentForm');
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }

            const payload = {
                agent_id: document.getElementById('agentId').value,
                first_name: document.getElementById('firstName').value,
                last_name: document.getElementById('lastName').value,
                email: document.getElementById('email').value,
                phone: document.getElementById('phone').value,
                dob: document.getElementById('dob').value,
                gender: document.getElementById('gender').value,
                address: document.getElementById('address').value,
                city: document.getElementById('city').value,
                state: document.getElementById('state').value,
                zip_code: document.getElementById('zipCode').value,
                location_description: document.getElementById('locationDescription').value,
                credit_limit: parseFloat(document.getElementById('creditLimit').value) || 0,
                commission_rate: parseFloat(document.getElementById('commissionRate').value) || 0,
                status: document.getElementById('accountStatus').value,
                notes: document.getElementById('agentNotes').value,
                username: document.getElementById('username').value,
                temp_password: document.getElementById('tempPassword').value
            };

            try {
                setBusy(true, editingAgentId ? 'Updating agent...' : 'Creating agent...');

                if (editingAgentId) {
                    // Update
                    payload.id = editingAgentId;
                    await axios.post('/loto/api/agent/update', payload, { withCredentials: true });
                    alert('Agent updated successfully');
                } else {
                    await axios.post('/loto/api/agent/create', payload, { withCredentials: true });
                    alert('Agent created successfully');
                }

                // Close modal, reset and refresh list
                const modalEl = document.getElementById('createAgentModal');
                const modal = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
                modal.hide();
                form.reset();
                editingAgentId = null;
                document.getElementById('createAgentModalLabel').textContent = 'Create New Agent';
                document.querySelector('#createAgentModal .btn-primary').innerHTML = '<i class="fas fa-save me-2"></i>Create Agent';

                await fetchAgents();
            } catch (err) {
                console.error('Agent create/update failed', err);
                alert('Operation failed. See console for details.');
            } finally {
                setBusy(false);
            }
        }

        // Agent management functions
        function viewAgent(agentId) {
            const agent = sampleAgents.find(a => String(a.id) === String(agentId));
            if (agent) {
                const details = `Agent Details:\n\nName: ${agent.firstName} ${agent.lastName}\nID: ${agent.id}\nEmail: ${agent.email}\nPhone: ${agent.phone}\nLocation: ${agent.location}\nStatus: ${agent.status}\nBalance: ₦${agent.currentBalance}\nTotal Bets: ${agent.totalBets}\nTotal Commission: ₦${agent.totalCommission}`;
                alert(details);
            }
        }

        // Open edit modal and prefill
        function editAgent(agentId) {
            const agent = sampleAgents.find(a => String(a.id) === String(agentId));
            if (!agent) return alert('Agent not found');

            editingAgentId = agentId;
            document.getElementById('agentId').value = agent.id;
            document.getElementById('firstName').value = agent.firstName;
            document.getElementById('lastName').value = agent.lastName;
            document.getElementById('email').value = agent.email;
            document.getElementById('phone').value = agent.phone;
            document.getElementById('dob').value = agent.joinDate || '';
            document.getElementById('gender').value = agent.gender || '';
            document.getElementById('address').value = agent.address || '';
            document.getElementById('city').value = agent.location || '';
            document.getElementById('state').value = agent.state || '';
            document.getElementById('zipCode').value = agent.zipCode || '';
            document.getElementById('locationDescription').value = agent.locationDescription || '';
            document.getElementById('creditLimit').value = agent.creditLimit || 0;
            document.getElementById('commissionRate').value = agent.commissionRate || 0;
            document.getElementById('accountStatus').value = agent.status || 'active';
            document.getElementById('agentNotes').value = agent.notes || '';
            document.getElementById('username').value = agent.username || '';
            document.getElementById('tempPassword').value = '';

            document.getElementById('createAgentModalLabel').textContent = 'Edit Agent';
            document.querySelector('#createAgentModal .btn-primary').innerHTML = '<i class="fas fa-save me-2"></i>Update Agent';

            const modalEl = document.getElementById('createAgentModal');
            const modal = new bootstrap.Modal(modalEl);
            modal.show();
        }

        async function suspendAgent(agentId) {
            if (!confirm('Are you sure you want to suspend this agent?')) return;
            try {
                setBusy(true, 'Suspending agent...');
                await axios.put('/loto/api/agent/update', { id: agentId, status: 'suspended' }, { withCredentials: true });
                await fetchAgents();
                alert('Agent suspended');
            } catch (err) {
                console.error(err);
                alert('Failed to suspend agent');
            } finally {
                setBusy(false);
            }
        }

        async function activateAgent(agentId) {
            try {
                setBusy(true, 'Activating agent...');
                await axios.put('/loto/api/agent/update', { id: agentId, status: 'active' }, { withCredentials: true });
                await fetchAgents();
                alert('Agent activated');
            } catch (err) {
                console.error(err);
                alert('Failed to activate agent');
            } finally {
                setBusy(false);
            }
        }

        // Delete agent (hard delete)
        async function deleteAgent(agentId) {
            if (!confirm('Are you sure you want to permanently delete this agent? This cannot be undone.')) return;
            try {
                setBusy(true, 'Deleting agent...');
                // axios.delete requires data in config
                await axios.delete('/loto/api/agent/delete', { data: { id: agentId }, withCredentials: true });
                await fetchAgents();
                alert('Agent deleted');
            } catch (err) {
                console.error('Delete failed', err);
                alert('Failed to delete agent. See console for details.');
            } finally {
                setBusy(false);
            }
        }

        // Quick change status handler
        async function changeAgentStatus(agentId, newStatus) {
            try {
                setBusy(true, 'Updating status...');
                await axios.post('/loto/api/agent/update', { id: agentId, status: newStatus }, { withCredentials: true });
                await fetchAgents();
            } catch (err) {
                console.error('Status update failed', err);
                alert('Failed to update status. See console for details.');
                // revert UI to previous state by reloading agents
                await fetchAgents();
            } finally {
                setBusy(false);
            }
        }
    </script>
</body>
</html>