<?php include_once('includes/head.php'); ?>

<?php include_once('includes/header.php'); ?>
    <?php include_once('includes/sidebar.php'); ?>
    <!-- Breadcrumb -->
    <section class="ht-breadcrumb-area">
        <div class="container">
            <div class="ht-breadcrumb-heading">
                <h2 class="ht-breadcrumb-title">Gallery</h2>
                <ul class="ht-breadcrumb-list">
                    <li><a href="index.php">Home</a></li>
                    <li><i class="fa-solid fa-chevron-right"></i></li>
                    <li class="active">Gallery</li>
                </ul>
            </div>
        </div>
    </section>

    <!-- Gallery -->
    <section class="gallery-area section-padding">
        <div class="container">
            <div class="section-header text-center mb-40">
                <h2 class="title">Our Gallery</h2>
                <p class="lead">A selection of images highlighting our work and events.</p>
            </div>

            <div class="gallery-grid">
                <?php
                // Load images from public/assets/gallery (jpg, jpeg, png, gif)
                $galleryDir = __DIR__ . '/../../public/assets/gallery';
                $files = [];
                if (is_dir($galleryDir)) {
                    $files = glob($galleryDir . '/*.{jpg,jpeg,png,gif}', GLOB_BRACE);
                    // sort by name
                    natsort($files);
                }
                foreach ($files as $f):
                    $name = basename($f);
                    // Use absolute URL path to public folder so requests resolve correctly
                    $relPath = '/kl/public/assets/gallery/' . $name;
                ?>
                <div class="gallery-item">
                    <a href="<?php echo $relPath; ?>" title="<?php echo htmlspecialchars($name); ?>">
                        <img class="lazy" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" data-src="<?php echo $relPath; ?>" alt="<?php echo htmlspecialchars($name); ?>" loading="lazy">
                        <div class="overlay"><i class="fas fa-search"></i></div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Footer + scripts -->
    <?php include_once('includes/footer.php'); ?>
    <?php include_once('includes/scripts.php'); ?>

    <style>
    .gallery-area .section-header .title{font-size:28px;margin-bottom:6px}
    .gallery-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:18px}
    .gallery-item{position:relative;overflow:hidden;border-radius:8px}
    .gallery-item img{width:100%;height:220px;object-fit:cover;display:block;transition:transform .35s ease, opacity .45s ease;opacity:0}
    .gallery-item img.lazy-loaded{opacity:1}
    .gallery-item .overlay{position:absolute;inset:0;background:linear-gradient(180deg,rgba(0,0,0,0) 40%,rgba(0,0,0,0.35));display:flex;align-items:flex-end;justify-content:center;padding:12px;opacity:0;transition:opacity .25s}
    .gallery-item:hover img{transform:scale(1.06)}
    .gallery-item:hover .overlay{opacity:1}
    .gallery-item .overlay i{color:#fff;font-size:18px}
    @media(max-width:768px){.gallery-item img{height:160px}}
    </style>

    <script>
    (function(){
        // Initialize Magnific Popup if available
        if (window.jQuery && jQuery().magnificPopup) {
            jQuery(document).ready(function($){
                $('.gallery-grid').magnificPopup({
                    delegate: 'a',
                    type: 'image',
                    gallery: { enabled: true },
                    image: { titleSrc: 'title' }
                });
            });
        }

        // Lazy-load thumbnails with IntersectionObserver
        function initLazy() {
            var lazyImgs = Array.prototype.slice.call(document.querySelectorAll('.gallery-item img.lazy'));
            if (!lazyImgs.length) return;
            if ('IntersectionObserver' in window) {
                var io = new IntersectionObserver(function(entries, observer){
                    entries.forEach(function(entry){
                        if (entry.isIntersecting) {
                            var img = entry.target;
                            img.src = img.dataset.src;
                            img.classList.remove('lazy');
                            img.classList.add('lazy-loaded');
                            observer.unobserve(img);
                        }
                    });
                }, { rootMargin: '200px 0px' });
                lazyImgs.forEach(function(img){ io.observe(img); });
            } else {
                // fallback: load all
                lazyImgs.forEach(function(img){ img.src = img.dataset.src; img.classList.add('lazy-loaded'); });
            }
        }

        if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', initLazy); else initLazy();
    })();
    </script>
</body>
</html>