<!DOCTYPE html>
<html lang="en" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Blue-Extra Lotto Agent Portal">
    <link rel="shortcut icon" href="../images/favicon.png">
    <title>Agent Portal Login | Blue-Extra Lotto</title>
    <!-- FontAwesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/loto/public/assets/css/dashlite9b70.css?ver=3.3.0">
    <link id="skin-default" rel="stylesheet" href="/loto/public/assets/css/theme9b70.css?ver=3.3.0">
    <style>
        .auth-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .auth-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
            padding: 40px 30px;
        }
        .auth-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .auth-title {
            font-size: 24px;
            font-weight: 600;
            color: #364a63;
            margin-bottom: 8px;
        }
        .auth-subtitle {
            color: #6c757d;
            font-size: 14px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #364a63;
            font-size: 14px;
        }
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #e3ebf6;
            border-radius: 5px;
            font-size: 14px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .password-wrapper {
            position: relative;
        }
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #9aa0ac;
            cursor: pointer;
        }
        .btn-primary {
            width: 100%;
            padding: 12px;
            background: #667eea;
            border: none;
            border-radius: 5px;
            color: white;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        .btn-primary:hover {
            background: #5a6fd8;
        }
        .btn-primary:disabled {
            background: #9aa0ac;
            cursor: not-allowed;
        }
        .forgot-link {
            text-align: center;
            margin-top: 20px;
        }
        .forgot-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }
        .forgot-link a:hover {
            text-decoration: underline;
        }
        .security-note {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e3ebf6;
            color: #6c757d;
            font-size: 12px;
        }

        /* Toast Notification Styles */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 350px;
        }
        .toast {
            background: white;
            border-radius: 8px;
            padding: 16px;
            margin-bottom: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            border-left: 4px solid;
            display: flex;
            align-items: center;
            animation: slideIn 0.3s ease;
            transform: translateX(400px);
            transition: transform 0.3s ease;
        }
        .toast.show {
            transform: translateX(0);
        }
        .toast.success {
            border-left-color: #10b981;
        }
        .toast.error {
            border-left-color: #ef4444;
        }
        .toast-icon {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
            font-size: 12px;
        }
        .toast.success .toast-icon {
            background: #10b981;
            color: white;
        }
        .toast.error .toast-icon {
            background: #ef4444;
            color: white;
        }
        .toast-content {
            flex: 1;
        }
        .toast-title {
            font-weight: 600;
            font-size: 14px;
            margin-bottom: 4px;
        }
        .toast-message {
            font-size: 13px;
            color: #6b7280;
        }
        .toast-close {
            background: none;
            border: none;
            color: #9ca3af;
            cursor: pointer;
            margin-left: 12px;
            font-size: 14px;
        }
        .toast-close:hover {
            color: #374151;
        }

        @keyframes slideIn {
            from {
                transform: translateX(400px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes slideOut {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(400px);
                opacity: 0;
            }
        }
    </style>
</head>

<body class="nk-body bg-white">
    <!-- Toast Container -->
    <div class="toast-container" id="toastContainer"></div>

    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1 class="auth-title">Agent Portal Login</h1>
                <p class="auth-subtitle">Blue-Extra Lotto Access</p>
            </div>
            
            <form id="loginForm">
                <div class="form-group">
                    <label class="form-label" for="agentId">Agent ID / Username</label>
                    <input type="text" class="form-control" id="agentId" placeholder="Enter your agent ID or username" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="password">Passcode / Password</label>
                    <div class="password-wrapper">
                        <input type="password" class="form-control" id="password" placeholder="Enter your passcode" required>
                        <button type="button" class="password-toggle" id="passwordToggle">
                            <i class="fas fa-eye" id="passwordIcon"></i>
                        </button>
                    </div>
                </div>
                
                <button type="submit" class="btn-primary" id="loginBtn">
                    Sign In
                </button>
            </form>
            
            <div class="forgot-link">
                <a href="#">Forgot Passcode? Contact Supervisor.</a>
            </div>
            
            <div class="security-note">
                <i class="fas fa-shield-alt me-1"></i>
                Secure Agent Portal • Authorized Access Only
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>
        // Toast Notification System
        class Toast {
            static show({ type = 'success', title, message, duration = 5000 }) {
                const toastContainer = document.getElementById('toastContainer');
                const toastId = 'toast-' + Date.now();
                
                const toast = document.createElement('div');
                toast.className = `toast ${type}`;
                toast.id = toastId;
                toast.innerHTML = `
                    <div class="toast-icon">
                        <i class="fas ${type === 'success' ? 'fa-check' : 'fa-exclamation'}"></i>
                    </div>
                    <div class="toast-content">
                        <div class="toast-title">${title}</div>
                        <div class="toast-message">${message}</div>
                    </div>
                    <button class="toast-close" onclick="Toast.close('${toastId}')">
                        <i class="fas fa-times"></i>
                    </button>
                `;
                
                toastContainer.appendChild(toast);
                
                // Animate in
                setTimeout(() => toast.classList.add('show'), 10);
                
                // Auto remove after duration
                if (duration > 0) {
                    setTimeout(() => Toast.close(toastId), duration);
                }
                
                return toastId;
            }
            
            static close(toastId) {
                const toast = document.getElementById(toastId);
                if (toast) {
                    toast.style.animation = 'slideOut 0.3s ease';
                    setTimeout(() => {
                        if (toast.parentNode) {
                            toast.parentNode.removeChild(toast);
                        }
                    }, 300);
                }
            }
            
            static success(message, title = 'Success!') {
                return this.show({
                    type: 'success',
                    title,
                    message
                });
            }
            
            static error(message, title = 'Error!') {
                return this.show({
                    type: 'error',
                    title,
                    message
                });
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Password visibility toggle
            const passwordToggle = document.getElementById('passwordToggle');
            const passwordInput = document.getElementById('password');
            const passwordIcon = document.getElementById('passwordIcon');
            
            passwordToggle.addEventListener('click', function() {
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    passwordIcon.className = 'fas fa-eye-slash';
                } else {
                    passwordInput.type = 'password';
                    passwordIcon.className = 'fas fa-eye';
                }
            });
            
            axios.defaults.withCredentials = true;

            // Form submission
            const loginForm = document.getElementById('loginForm');
            const loginBtn = document.getElementById('loginBtn');
            
            loginForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const agentId = document.getElementById('agentId').value;
                const password = document.getElementById('password').value;
                
                // Basic validation
                if (!agentId || !password) {
                    Toast.error('Please fill in all fields', 'Missing Information');
                    return;
                }
                
                // Show loading state
                const originalText = loginBtn.innerHTML;
                loginBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Signing In...';
                loginBtn.disabled = true;
                
                // Perform real axios POST to admin login endpoint
                axios.post('/loto/api/adminauth/loginadmin', {
                    email: agentId,
                    password: password
                }).then(function(response) {
                    // Normalize response shapes
                    const d = response && response.data ? response.data : response;
                    // Success cases: { state: true, message: {...} } or { success: true, data: {...} }
                    const success = (d && (d.state === true || d.success === true || d.status === 'success')) || response.status === 200;
                    if (success) {
                        Toast.success('Welcome back! Redirecting to admin dashboard...', 'Login Successful');
                        // short delay to allow toast to show
                        setTimeout(() => {
                            window.location.href = '/loto/admin/';
                        }, 800);
                    } else {
                        const msg = (d && (d.message || d.error || d.data)) ? (d.message || d.error || JSON.stringify(d.data)) : 'Invalid credentials. Please try again.';
                        Toast.error(msg, 'Login Failed');
                    }
                }).catch(function(err) {
                    console.error('Login error', err);
                    let msg = 'Login failed. Please try again.';
                    if (err && err.response && err.response.data) {
                        const dd = err.response.data;
                        msg = dd.message || dd.error || JSON.stringify(dd);
                    }
                    Toast.error(msg, 'Login Error');
                }).finally(function(){
                    // Reset button
                    loginBtn.innerHTML = originalText;
                    loginBtn.disabled = false;
                });
            });
            
            // Demo toasts on page load
            setTimeout(() => {
                // Toast.success('System ready for login', 'Welcome');
            }, 1000);
        });
    </script>
</body>
</html>